/* ---------- */
/* miscdefs.h */
/* ---------- */
/* ----------------------------------------------- */
/* FUNCTION PROTOTYPES FOR MISCELLANEOUS FUNCTIONS */
/* ----------------------------------------------- */
# if defined(__MISCDEFS_H__)
#		/* Do Nothing. */
# else
#	define	__MISCDEFS_H__
#
# if !defined(__DEFCODES)
#
typedef	long     double		LDBL;
typedef	unsigned char		UCHAR;
typedef	unsigned int		UINT;
typedef unsigned long		ULONG;
typedef	unsigned short		USHORT;
#
# endif
#
# ifndef DEBUG
#	undef	P
#	define	P( F )
# else
#	undef	P
#	define	P( F )		F
# endif
#
# undef	SQR
#define	SQR(X)	((X) * (X))
#
# undef	TRUE
#define	TRUE	1
# undef	FALSE
#define	FALSE	0
#
# undef F
#
# if defined(__STDC__) || defined(__PROTO__)
#	define  F( P )  P
# else
#	define  F( P )  ()
# endif

typedef	struct	InitDataStru
    {
	UINT	UserSeed;		/* Seed Provided by User     */
	UINT	SeedSrce;		/* -1: Source is time of day */
	char	*GenName;		/* ASCII label for Generator */
	int	(*RandFun) F((void));	/* Address of Generator      */
    }
	INIT_DATA_STRU;

/* INDENT OFF */
extern	void	AbortGracefully F((void));
extern	double	BinCoef F((double, double));
extern	double	CalcHarm F((int, UINT));
extern	void	CalcMeanStdDev F((UINT, double *, double *));
extern	void	ChiSqDist F((double, double, double *, double *));
extern	void	ClrBitArray F((UCHAR *, UINT, UINT, UCHAR));
extern	void	CmplBit F((UCHAR *, UINT));
extern	void	CopyBits F((UCHAR *, UINT, UINT, UCHAR *, UINT));
extern	double	dM77_rand F((void));
extern	void	drand F((double *));
extern	double	dRand250 F((void));
extern	double	Drand55 F((long *));
extern	void	DrandSeed F((UINT));
extern	double	Dranmar F((void));

extern	long	genr_rand F((long, long, long, long, long));
extern	long	genr_rand_diff F((void));
extern	long	genr_rand_port F((long));
extern	void	GetChr F((char *, char *));
extern	void	GetDbl F((char *, double *));
extern	void	GetInitialData F((struct InitDataStru *));
extern	long	get_init_rand F((long));
extern	long	get_init_rand_port F((void));
extern	void	GetInt F((char *, int *));

extern	void	GetLDBL F((char *, LDBL *));
extern	void	GetLong F((char *, long *));
extern	void	GetUint F((char *, UINT *));
extern	int	iM77_rand F((void));
extern	void	init_rand_comb F((long, long));
extern	long	init_rand_port F((long));
extern	int	IRand_MZ F((void));
extern	int	Iranmar F((void));
extern	int	Irand55 F((long *));
extern	void	KSCalc F((double *, int, double *, double *,
			double *, double *));
extern	double	KSmirInv F((int, double));
extern	double	KSmirnov F((int, double));
extern	long	LRand_MZ F((void));
extern	long	Lrand55 F((long *));
extern	void	M77_rand_init F((UINT));
extern	long	mult_mod F((long, long, long));
extern	void	Rand250_init F((int));
extern	UINT	Rand250 F((void));
extern	UINT	Rand250n F((UINT));
extern	long	rand_comb F((void));
extern	double	Rand_MZ F((void));
extern	void	Rand_MZ_Init F((ULONG));
extern	long	rand_port F((void));
extern	double	rand_rect_comb F((void));
extern	double	rand_rect_port F((void));
extern	void	ranmar F((double *, int));
extern	void	ReverseBits F((UCHAR *, UINT, UINT, UCHAR *, UINT));
extern	void	ReverseInSitu F((UCHAR *, UINT, UINT));
extern	void	rmarin F((UINT, UINT));
extern	void	SetBit F((UCHAR *, UINT, UCHAR));
extern	long	skip_ahead F((long, long, long, long));
extern	long	double Stirling1 F((double, double));
extern	long	double Stirling2 F((double, double));
extern	UCHAR	TestBit F((UCHAR *, UINT));
extern	void	VRand_MZ F((double *, int));

# undef F
/* INDENT ON */
# endif				/* <<< __MISCDEFS_H__ >>> */
